define([
    'underscore',
    'backbone',
    'App',
    'text!modules/feedback/feedback.html',
    'text!modules/page/content/_primary-header.html',
    'FormParams',
],
function (_, Backbone, app, template, _primaryHeaderTemplate) {
    'use strict';

    return Backbone.Marionette.View.extend({
        template: _.template(template),
        attributes: {
            'id': 'feedback',
            'class': 'type-interior',
        },
        events: {
            'click #back-btn': 'routeToAppointments',
            'click #cancel-feedback': 'routeToAppointments',
            'click #submit-feedback': 'submitFeedback',
            'change input[type="radio"]': 'handlefeedBackChange',
            'change #feedback-comment': 'handlefeedBackChange',
            'change .rating': 'handlefeedBackChange',
        },
        ui: {
            cancel: '#cancel-feedback',
            submit: '#submit-feedback',
            select: '.rating',
            radio: '.radio-rate',
        },
        initialize: function(options) {
            this.feedbackModel = new Backbone.Model();
        },
        onRender: function() {
            this.ui.submit[0].disabled = true;
            this.$el.trigger('create');
            // eslint-disable-next-line max-len
        },
        routeToAppointments: function() {
            Backbone.history.navigate('appointments', {trigger: true});
        },
        handlefeedBackChange: function(e) {
            var value;
            var name;
            value = e.target.value;
            name = e.target.name;
            this.feedbackModel.set(name, value);
            if (name === 'recommendationRating' && value !== '') {
                this.ui.select[0].value = value;
                this.ui.radio[value].checked = true;
                this.ui.submit[0].disabled = false;
            } else if (name === 'recommendationRating' && value === '') {
                this.ui.submit[0].disabled = true;
            }
        },
        submitFeedback: function (e) {
            var TWO_SECONDS = 2000;
            var self;

            this.ui.submit[0].disabled = true;
            this.ui.cancel[0].disabled = true;
            
            self = this;

            this.feedbackModel.save({}, {
                url: app.resources.get('feedback').get('href'),
                success: function() {
                    $('.message')
                        .eq(0)
                        .removeClass('display-none')
                        .text('Thank you!  Your feedback has been submitted.');

                    setTimeout(function() {
                        // TODO does this have a 2 second timeout????
                        // Best guess is that the view is not finished rendering
                        // This needs to fixed. (Not updating as a part of the upgrade story though)
                        var cancel = self.getUI('cancel');
                        cancel[0].disabled = false;
                        self.routeToAppointments();
                    }, TWO_SECONDS);
                },
            });
        },
        templateContext: {primaryHeader: _.template(_primaryHeaderTemplate)},
    });
});
